/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.client.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.slf4j.Logger;
import xfacthd.buddingcrystals.common.BCContent;
import xfacthd.buddingcrystals.common.util.CrystalLoader;

public final class ExportCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String MSG_NO_SUCH_CRYSTAL = "commands.buddingcrystals.no_such_crystal";
    public static final String MSG_EXPORT_ERROR = "commands.buddingcrystals.export_error";
    public static final String MSG_CRYSTALS_EXPORTED = "commands.buddingcrystals.crystals_exported";
    public static final String MSG_CRYSTALS_OVERWRITTEN = "commands.buddingcrystals.crystals_overwritten";
    public static final String MSG_CRYSTAL_EXPORTED = "commands.buddingcrystals.crystal_exported";
    public static final String MSG_CRYSTAL_OVERWRITTEN = "commands.buddingcrystals.crystal_overwritten";
    public static final String MSG_CRYSTAL_EXISTS = "commands.buddingcrystals.crystal_exists";
    private static final DynamicCommandExceptionType NO_SUCH_CRYSTAL = new DynamicCommandExceptionType(crystal -> new TranslatableComponent(MSG_NO_SUCH_CRYSTAL, new Object[]{crystal}));
    private static final Dynamic2CommandExceptionType EXPORT_ERROR = new Dynamic2CommandExceptionType((name, error) -> new TranslatableComponent(MSG_EXPORT_ERROR, new Object[]{name, error}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"buddingcrystals").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"export_all").executes(stack -> ExportCommand.exportAll((CommandContext<CommandSourceStack>)stack, false))).then(Commands.m_82129_((String)"overwrite_existing", (ArgumentType)BoolArgumentType.bool()).executes(stack -> ExportCommand.exportAll((CommandContext<CommandSourceStack>)stack, true))))).then(Commands.m_82127_((String)"export").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"crystal", (ArgumentType)StringArgumentType.string()).suggests(ExportCommand::getCrystalSuggestions).executes(stack -> ExportCommand.exportSpecific((CommandContext<CommandSourceStack>)stack, false))).then(Commands.m_82129_((String)"overwrite_existing", (ArgumentType)BoolArgumentType.bool()).executes(stack -> ExportCommand.exportSpecific((CommandContext<CommandSourceStack>)stack, true))))));
    }

    private static int exportAll(CommandContext<CommandSourceStack> ctx, boolean withOverwrite) throws CommandSyntaxException {
        boolean overwrite = withOverwrite && BoolArgumentType.getBool(ctx, (String)"overwrite_existing");
        int total = BCContent.builtinNames().size();
        int count = 0;
        int overwritten = 0;
        for (String name : BCContent.builtinNames()) {
            Result res = ExportCommand.exportCrystalDefinition(name, overwrite);
            if (res == Result.EXISTS) continue;
            ++count;
            if (res != Result.OVERWRITTEN) continue;
            ++overwritten;
        }
        if (overwrite) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent(MSG_CRYSTALS_OVERWRITTEN, new Object[]{count, total, overwritten}), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent(MSG_CRYSTALS_EXPORTED, new Object[]{count, total, total - count}), true);
        }
        return count;
    }

    private static int exportSpecific(CommandContext<CommandSourceStack> ctx, boolean withOverwrite) throws CommandSyntaxException {
        boolean overwrite = withOverwrite && BoolArgumentType.getBool(ctx, (String)"overwrite_existing");
        String crystal = StringArgumentType.getString(ctx, (String)"crystal");
        if (!BCContent.isBuiltin(crystal)) {
            throw NO_SUCH_CRYSTAL.create((Object)crystal);
        }
        Result result = ExportCommand.exportCrystalDefinition(crystal, overwrite);
        if (result == Result.EXISTS) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)new TranslatableComponent(MSG_CRYSTAL_EXISTS, new Object[]{crystal}));
            return 0;
        }
        if (result == Result.EXPORTED) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent(MSG_CRYSTAL_EXPORTED, new Object[]{crystal}), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent(MSG_CRYSTAL_OVERWRITTEN, new Object[]{crystal}), true);
        }
        return 1;
    }

    private static CompletableFuture<Suggestions> getCrystalSuggestions(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(BCContent.builtinNames(), (SuggestionsBuilder)builder);
    }

    private static Result exportCrystalDefinition(String name, boolean overwrite) throws CommandSyntaxException {
        Path path = CrystalLoader.CRYSTAL_PATH.resolve(name + ".json");
        boolean exists = Files.exists(path, new LinkOption[0]);
        if (exists && !overwrite) {
            return Result.EXISTS;
        }
        String json = CrystalLoader.export(name);
        try {
            Files.writeString(path, (CharSequence)json, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("Encountered an error while exporting builtin crystal definition '" + name + "'", (Throwable)e);
            throw EXPORT_ERROR.create((Object)name, (Object)e.getMessage());
        }
        return exists ? Result.OVERWRITTEN : Result.EXPORTED;
    }

    private static enum Result {
        EXISTS,
        EXPORTED,
        OVERWRITTEN;

    }
}

